/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.EncryptableProperties;
import program.FTPOperator;
import program.Main;
import settings.ConfigFile;

public class Settings
extends Application {
    @FXML
    private TextField ipField;
    @FXML
    private TextField userField;
    @FXML
    private TextField configNameField;
    @FXML
    private TextField choiceField;
    @FXML
    private PasswordField passField;
    @FXML
    private CheckBox soundsCheckBox;
    @FXML
    private CheckBox animationsCheckBox;
    @FXML
    private ListView<ConfigFile> configList;
    private ObservableList<ConfigFile> listConfigurations;
    private ConfigFile selection = null;
    private String defaultConfig = "none";
    private boolean sounds = true;
    private boolean animations = true;
    private FTPOperator ftpOperator = null;
    private Stage stage;
    private Main main;
    private StandardPBEStringEncryptor encryptor;
    public static String cryptKey = "kjkszpj";
    private final File configFolder = new File("./conf");
    private final File defaultConfigFile = new File("./conf/defaultConfig.properties");

    public Settings(Stage primaryStage, FTPOperator ftOperator, Main main) {
        this.ftpOperator = ftOperator;
        this.main = main;
        this.init();
        try {
            this.start(primaryStage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        this.encryptor = new StandardPBEStringEncryptor();
        this.encryptor.setPassword(cryptKey);
        this.listConfigurations = FXCollections.observableArrayList();
        this.loadConfigs();
    }

    public void start(Stage primaryStage) throws Exception {
        this.stage = primaryStage;
        primaryStage.setTitle("AEGIS - Settings");
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/AEGIS_Settings.fxml"));
        loader.setController((Object)this);
        Parent root = (Parent)loader.load();
        Scene scene = new Scene(root);
        primaryStage.setScene(scene);
        this.choiceField.setText("/");
        this.configList.setItems(this.listConfigurations);
        MenuItem delete = new MenuItem("Delete");
        delete.setOnAction(e -> this.deleteConfig());
        MenuItem defaultServer = new MenuItem("Make Default");
        defaultServer.setOnAction(e -> this.setDefault());
        MenuItem removeDefault = new MenuItem("Remove Default");
        removeDefault.setOnAction(e -> this.removeDefault());
        this.configList.setContextMenu(new ContextMenu(new MenuItem[]{delete, defaultServer, removeDefault}));
        Properties prop = this.loadDefaultConfig(this.defaultConfigFile);
        if (!prop.isEmpty()) {
            this.sounds = prop.getProperty("sounds").equals("true");
            this.animations = prop.getProperty("animations").equals("true");
        }
        this.soundsCheckBox.setSelected(this.sounds);
        this.animationsCheckBox.setSelected(this.animations);
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                Settings.this.main.loadDefault();
            }
        });
        primaryStage.getIcons().add((Object)this.main.appImg);
        primaryStage.setResizable(false);
        primaryStage.show();
    }

    @FXML
    private void animationsChanged() {
        this.animations = this.animationsCheckBox.isSelected();
        this.createDefaultConfig();
    }

    @FXML
    private void soundsChanged() {
        this.sounds = this.soundsCheckBox.isSelected();
        this.createDefaultConfig();
    }

    @FXML
    private void saveConfiguration() {
        try {
            Properties prop = this.createConfig();
            if (this.configList.getSelectionModel().getSelectedItem() != null) {
                FileOutputStream fos = new FileOutputStream(((ConfigFile)this.configList.getSelectionModel().getSelectedItem()).getFile());
                prop.store(fos, null);
                fos.close();
            } else {
                if (!this.configFolder.exists()) {
                    this.configFolder.mkdir();
                }
                FileOutputStream fos = new FileOutputStream(String.valueOf(this.configFolder.getPath()) + "/config-" + System.currentTimeMillis() / 1000L + ".properties");
                prop.store(fos, null);
                fos.close();
            }
            this.main.playSound("security_protocols.mp3");
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: File Not Found while saving config");
        }
        catch (NullPointerException e) {
            this.main.playSound("user_input.mp3");
            Alert alert = new Alert(Alert.AlertType.ERROR);
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)this.main.appImg);
            alert.setTitle("Missing parameters");
            alert.setHeaderText(e.getMessage());
            alert.setContentText("Please insert necessary informations.");
            alert.showAndWait();
        }
        catch (IOException e) {
            System.err.println("ERROR: IOException while saving config");
        }
        this.clearFields();
        this.loadConfigs();
    }

    @FXML
    private void connectToServer() {
        if (this.configList.getSelectionModel().getSelectedItem() != null) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(((ConfigFile)this.configList.getSelectionModel().getSelectedItem()).getFile()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.main.loadDefault();
            this.ftpOperator.loadDefault(prop);
            this.stage.close();
        } else {
            try {
                Properties prop = this.createConfig();
                this.ftpOperator.loadDefault(prop);
                this.stage.close();
            }
            catch (NullPointerException e) {
                this.main.playSound("user_input.mp3");
                Alert alert = new Alert(Alert.AlertType.ERROR);
                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                stage.getIcons().add((Object)this.main.appImg);
                alert.setTitle("Missing parameters");
                alert.setHeaderText(e.getMessage());
                alert.setContentText("Please insert necessary informations.");
                alert.showAndWait();
            }
        }
    }

    @FXML
    private void serverClick(MouseEvent e) {
        if (e.getButton() == MouseButton.PRIMARY) {
            ConfigFile selected = (ConfigFile)this.configList.getSelectionModel().getSelectedItem();
            if (selected == this.selection) {
                this.configList.getSelectionModel().clearSelection();
                selected = null;
            }
            this.selection = selected;
            if (selected != null) {
                this.ipField.setText(selected.getProperty("server"));
                this.userField.setText(selected.getProperty("user"));
                this.configNameField.setText(selected.getProperty("configName"));
                this.passField.setText(this.encryptor.decrypt(selected.getProperty("pass")));
                this.choiceField.setText(selected.getProperty("root"));
            } else {
                this.clearFields();
            }
        }
    }

    private void clearFields() {
        this.ipField.setText("");
        this.configNameField.setText("");
        this.userField.setText("");
        this.passField.setText("");
        this.choiceField.setText("/");
    }

    private Properties createConfig() throws NullPointerException {
        EncryptableProperties prop = new EncryptableProperties(this.encryptor);
        prop.setProperty("configName", this.configNameField.getText());
        if (this.ipField.getText().equals("")) {
            throw new NullPointerException("Server field is empty!");
        }
        prop.setProperty("server", this.ipField.getText());
        if (this.userField.getText().equals("")) {
            throw new NullPointerException("User field is empty!");
        }
        prop.setProperty("user", this.userField.getText());
        prop.setProperty("pass", this.encryptor.encrypt(this.passField.getText()));
        if (this.choiceField.getText().contains("/") || this.choiceField.getText().contains("\\")) {
            prop.setProperty("root", this.choiceField.getText());
        } else {
            prop.setProperty("root", "/");
        }
        return prop;
    }

    private void loadConfigs() {
        this.listConfigurations.clear();
        File[] configs = this.configFolder.listFiles();
        if (configs != null) {
            File[] fileArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.getName().equals("defaultConfig.properties")) {
                    ConfigFile confFile = null;
                    try {
                        confFile = new ConfigFile(file);
                    }
                    catch (IOException e) {
                        System.err.println("ERROR: Cant load properties file!");
                    }
                    this.listConfigurations.add((Object)confFile);
                }
                ++n2;
            }
        }
    }

    private void deleteConfig() {
        ConfigFile selected;
        if (this.configList != null && (selected = (ConfigFile)this.configList.getSelectionModel().getSelectedItem()) != null) {
            selected.getFile().delete();
            this.loadConfigs();
            this.clearFields();
        }
    }

    private void setDefault() {
        if (this.configList != null && this.configList.getSelectionModel().getSelectedItem() != null) {
            this.defaultConfig = ((ConfigFile)this.configList.getSelectionModel().getSelectedItem()).getFile().getName();
            this.createDefaultConfig();
        }
    }

    private void removeDefault() {
        this.defaultConfig = "none";
        this.createDefaultConfig();
    }

    private void createDefaultConfig() {
        Properties prop = this.loadDefaultConfig(this.defaultConfigFile);
        if (!this.defaultConfig.equals("")) {
            if (this.defaultConfig.equals("none")) {
                prop.setProperty("defaultConfig", "");
            } else {
                prop.setProperty("defaultConfig", this.defaultConfig);
            }
        }
        if (prop.getProperty("defaultConfig") == null) {
            prop.setProperty("defaultConfig", "");
        }
        prop.setProperty("sounds", String.valueOf(this.sounds));
        prop.setProperty("animations", String.valueOf(this.animations));
        try {
            if (!this.configFolder.exists()) {
                this.configFolder.mkdir();
            }
            FileOutputStream fos = new FileOutputStream(this.defaultConfigFile);
            prop.store(fos, null);
            fos.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: File not found while saving default config!");
        }
        catch (IOException e) {
            System.err.println("ERROR: IO Exception while saving default config!");
        }
    }

    private Properties loadDefaultConfig(File defaultConfigFile) {
        Properties prop = new Properties();
        if (defaultConfigFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(defaultConfigFile);
                prop.load(fis);
                fis.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("ERROR: File not found while loading old config!");
            }
            catch (IOException e) {
                System.err.println("ERROR: IO Exception while loading old config!");
            }
        }
        return prop;
    }
}

